set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Table 9

**1. Preparing data: merging time-averaged up- and downstream weights into EUKLEMS data, calculate net aggregate up- and down-stream productivity growth
use $path_in\KLEMS_b2008_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/

	*Generate industry variable consistent with coding in IO weights file
	gen 	industry=1	if	code=="C"
	replace industry=2	if	code=="15t16"
	replace industry=3	if	code=="17t19"
	replace industry=4	if	code=="20"
	replace industry=5	if	code=="21t22"
	replace industry=6	if	code=="23"
	replace industry=7	if	code=="24"
	replace industry=8	if	code=="25"
	replace industry=9	if	code=="26"
	replace industry=10	if	code=="27t28"
	replace industry=11	if	code=="29"
	replace industry=12	if	code=="30t33"
	replace industry=13	if	code=="34t35"
	replace industry=14	if	code=="36t37"
	replace industry=15	if	code=="E"
	replace industry=16	if	code=="F"
	replace industry=17	if	code=="50"
	replace industry=18	if	code=="51"
	replace industry=19	if	code=="52"
	replace industry=20	if	code=="H"
	replace industry=21	if	code=="60t63"
	replace industry=22	if	code=="64"
	replace industry=23	if	code=="J"
	replace industry=24	if	code=="70"
	replace industry=25	if	code=="71t74"
	replace industry=26	if	code=="M"
	replace industry=27	if	code=="N"
	replace industry=28	if	code=="O"

	*Set productivity measure as country leave-out TFP
	local LP D1_lnTFPva_oth
		
	*Enforce productivity measure
	rename `LP' D1_LP1_EMP

	*Reshape to obtain TFP in wide form, to multiply with weights later on
	preserve
	keep country industry year D1_LP1_EMP
	reshape wide D1_LP1_EMP, i(country year) j(industry)
	save $path_temp\temp_TFPwide, replace
	restore
	
	*Merging in IO weights
	merge m:1 country industry using $path_in\IO_weights
	keep if _==3 /*all KLEMS countries are matched*/
	drop _ 
	
	*Merging in wide TFP
	merge m:1 country year using $path_temp\temp_TFPwide
	drop _ /*100% matched*/
	
	*Calculate country-level mean productivity growth among supplier (upstream) industries
	forvalues industry = 1(1)28 {
		gen D1_LP1_EMP_up`industry'=D1_LP1_EMP`industry'*w_up_`industry'
	}
	egen D1_LP1_EMP_net_up=rowtotal(D1_LP1_EMP_up*), missing
	label var D1_LP1_EMP_net_up "Aggregate productivity growth in upstream industries by industry-country-year"
	drop D1_LP1_EMP_up* w_up*
	
	*Calculate country-level mean productivity growth among customer (downstream) industries
	forvalues industry = 1(1)28 {
		gen D1_LP1_EMP_down`industry'=D1_LP1_EMP`industry'*w_down_`industry'
	}
	egen D1_LP1_EMP_net_down=rowtotal(D1_LP1_EMP_down*), missing
	label var D1_LP1_EMP_net_down "Aggregate productivity growth in downstream industries by industry-country-year"
	drop D1_LP1_EMP_down* w_down* 
	forvalues industry = 1(1)28 {
		drop D1_LP1_EMP`industry'
	}
	
	egen ct=group(country year)
	egen ic=group(code country)
	egen it=group(code year)
	
	*Rename up/down as supplier & customer
	rename D1_LP1_EMP_net_up D1_LP1_EMP_net_sup
	rename D1_LP1_EMP_net_down D1_LP1_EMP_net_cus
	label var D1_LP1_EMP_net_sup "Supplier TFP growth"
	label var D1_LP1_EMP_net_cus "Customer TFP growth"

	*Standardize TFP terms
	drop if D1_LP1_EMP==.
	foreach var in D1_LP1_EMP  D1_LP1_EMP_net_cus D1_LP1_EMP_net_sup {
		sum `var' [w=weight_VA_c]
		gen temp`var'=r(sd)
		replace `var'=`var'/temp`var'
		drop temp`var'
	}	
save $path_temp\temp_T9, replace

		

**2. Table 9 upper panel: industry-level effects
use $path_temp\temp_T9, clear

	tsset cross year
	
	cap program drop storeestimates
	program define storeestimates
				est store T9_$col
				lincomest D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				estimates store own_$col
				est restore T9_$col
				lincomest D1_LP1_EMP_net_sup + L.D1_LP1_EMP_net_sup + L2.D1_LP1_EMP_net_sup + L3.D1_LP1_EMP_net_sup + L4.D1_LP1_EMP_net_sup + L5.D1_LP1_EMP_net_sup
				cap estimates store sup_$col
				est restore T9_$col
				lincomest D1_LP1_EMP_net_cus + L.D1_LP1_EMP_net_cus + L2.D1_LP1_EMP_net_cus + L3.D1_LP1_EMP_net_cus + L4.D1_LP1_EMP_net_cus + L5.D1_LP1_EMP_net_cus
				cap estimates store cus_$col
	end		
		
	local own 		"D1_LP1_EMP L.D1_LP1_EMP L2.D1_LP1_EMP L3.D1_LP1_EMP L4.D1_LP1_EMP L5.D1_LP1_EMP "
	local sup 		"D1_LP1_EMP_net_sup L.D1_LP1_EMP_net_sup L2.D1_LP1_EMP_net_sup L3.D1_LP1_EMP_net_sup L4.D1_LP1_EMP_net_sup L5.D1_LP1_EMP_net_sup"
	local cus 		"D1_LP1_EMP_net_cus L.D1_LP1_EMP_net_cus L2.D1_LP1_EMP_net_cus L3.D1_LP1_EMP_net_cus L4.D1_LP1_EMP_net_cus L5.D1_LP1_EMP_net_cus"
	local controls	"i.sectorgroup i.country*year i.country*i.bcycle"


	**Column 1: Employment
		global col=1
		qui xi:areg D1_lnEMP  `own' `sup' `cus' `controls' [w=weight_c], absorb(year) clus(ic) 
			storeestimates
			
	**Column 2: Hours worked
		global col=2
		qui xi:areg D1_lnH_EMP  `own' `sup' `cus' `controls' [w=weight_h_c], absorb(year) clus(ic)
			storeestimates

	**Column 3: Nominal wage bill
		global col=3
		qui xi:areg D1_lnLAB  `own' `sup' `cus'  `controls' [w=weight_h_c], absorb(year) clus(ic) 
			storeestimates

	**Column 4: Nominal value added
		global col=4
		qui xi:areg D1_lnVA  `own' `sup' `cus' `controls' [w=weight_VA_c], absorb(year)  clus(ic) 	
			storeestimates	
			
	**Column 5: Real value added
		global col=5
		qui xi:areg D1_lnVA_QI  `own' `sup' `cus' `controls' [w=weight_VA_c], absorb(year) clus(ic) 	
			storeestimates		

	**Column 6: Labor share
		global col=6
		qui xi:areg D1_lnlaborshare  `own' `sup' `cus'  `controls' [w=weight_VA_c], absorb(year) clus(ic) 	
			storeestimates	
	*Table
	esttab T9_1 T9_2 T9_3 T9_4 T9_5 T9_6, keep(`own' `sup' `cus') order(`own' `sup' `cus') b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 9, upper panel")
	
	foreach var in own sup cus  {
		dis "												`var' effects"
			esttab `var'_1 `var'_2 `var'_3 `var'_4 `var'_5 `var'_6, b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 9, upper panel")
		}	
		
		
**3. Table 9 bottom panel: aggregate effects
use $path_temp\temp_T9, clear
	
	tsset cross year
	
	cap program drop storeestimates
	program define storeestimates
				est store T9_$col
			cap lincomest D1_lnVA_LO + L.D1_lnVA_LO  + L2.D1_lnVA_LO    + L3.D1_lnVA_LO   + L4.D1_lnVA_LO    + L5.D1_lnVA_LO   
				cap estimates store aggN_$col
				est restore T9_$col
			cap lincomest D1_lnVA_QI_LO + L.D1_lnVA_QI_LO  + L2.D1_lnVA_QI_LO  + L3.D1_lnVA_QI_LO + L4.D1_lnVA_QI_LO  + L5.D1_lnVA_QI_LO 
				cap estimates store aggR_$col
				est restore T9_$col
	end		
		
	local aggR		"D1_lnVA_QI_LO L.D1_lnVA_QI_LO L2.D1_lnVA_QI_LO L3.D1_lnVA_QI_LO L4.D1_lnVA_QI_LO L5.D1_lnVA_QI_LO"
	local aggN		"D1_lnVA_LO L.D1_lnVA_LO L2.D1_lnVA_LO L3.D1_lnVA_LO L4.D1_lnVA_LO L5.D1_lnVA_LO"

	local controls	"i.sectorgroup i.country i.year"
	local controls	"i.sectorgroup"
			
	**Column 1: Employment
		global col=1
		qui xi:reg D1_lnEMP `aggR' `controls' [w=weight_c], clus(ic) 
			storeestimates
			
	**Column 2: Hours worked
		global col=2
		qui xi:reg D1_lnH_EMP `aggR' `controls' [w=weight_h_c],  clus(ic)
			storeestimates

	**Column 3: Nominal wage bill
		global col=3
		qui xi:reg D1_lnLAB `aggN' `controls' [w=weight_h_c],  clus(ic) 
			storeestimates

	**Column 4: Nominal value added
		global col=4
		qui xi:reg D1_lnVA `aggN' `controls' [w=weight_VA_c],  clus(ic) 	
			storeestimates	
			
	**Column 5: Real value added
		global col=5
		qui xi:reg D1_lnVA_QI `aggR' `controls' [w=weight_VA_c],  clus(ic) 	
			storeestimates		

	**Column 6: Labor share
		global col=6
		qui xi:reg D1_lnlaborshare `aggN' `controls' [w=weight_VA_c],  clus(ic) 	
			storeestimates	
				
	*Table
	esttab T9_1 T9_2 T9_3 T9_4 T9_5 T9_6, keep(`aggR' `aggN') order(`aggR'  `aggN') b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 9, bottom panel")
	
	foreach var in aggR {
		dis "												`var' effects"
			esttab `var'_1 `var'_2 `var'_5, b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 9, bottom panel")
		}				
	foreach var in aggN {
		dis "												`var' effects"
			esttab `var'_3 `var'_4 `var'_6, b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 9, bottom panel")
		}		

*Erase temporary files
	cap erase $path_temp\temp_T9.dta
